clear
clc
%---Extended Leapfrog algorithm---
%---up->u_1; um->u_{-1}; 
%---up3->w^*_3; um3->w^*_{-3}; 
%---wp3->w_3; wm3->w_{-3};

T = 0.5;
L = 6;
lambda = 1;

kappa = 1;
c_p = 1/2;
c_m = 1/2;

space = [0.4;0.2;0.1;0.05;0.025];%[0.6;0.3;0.15;0.075;0.0325];
ind = [10^(-6);10^(-5);10^(-4);10^(-3);10^(-2);0.03;0.1;0.3;0.5;1];%%

ap0 = @(x) c_p*exp(-x.^2); %initial envelope ------
am0 = @(x) c_m*exp(-x.^2);

omega = kappa^2/2;
kappa3 = 3*kappa;
omega3 = kappa3^2/2;
delta3 = -4*kappa^2; 

err = zeros(length(ind),1);
ep = zeros(length(ind),1);
time = zeros(length(ind),1);

for loop=1:1
    dx = space(loop);
    for i=1:length(ind)
        epsi = ind(i);
        beta = kappa*dx/epsi;
        beta3 = kappa3*dx/epsi;
        %------step size -----
        gamma = 1+max(abs(beta),1);
        gamma3 = 1+max(abs(beta3),1);
        dt = min([dx/2,dx^2/(2*epsi*gamma3)]);
       
        alpha = omega*dt/epsi;
        alpha3 = omega3*dt/epsi; 
        
        %---------------------------------------------------
        M = floor(2*L/dx);
        x = (-L:dx:L-dx)';
        N = ceil(T/dt);
        %u_p = zeros(M,1);
        up_new = zeros(M,1);
        up_exact = zeros(M,1);
        up3_exact = zeros(M,1);
        %u_m = zeros(M,1);
        um_new = zeros(M,1);
        um_exact = zeros(M,1);
        um3_exact = zeros(M,1);
        u_exact = zeros(M,1);
        
        if epsi>10^(-3)
            %---------------reference solution (original equaion) for large epsi------------------
            K = 6000;
            ddt = min(10^(-4),epsi/10);
            [c_u,kk,xx] =  ref(dt*N,ddt,K,epsi,L, lambda, kappa, c_p,c_m);
            for j=1:M
                if x(j)<=0
                    u_exact(j) = c_u.'*exp(1i*kk*(x(j)-L))/K;
                else
                    u_exact(j) = c_u.'*exp(1i*kk*(x(j)+L))/K;
                end
            end
        else
            %----------------reference solution (limit equation) for small epsi---
            K = 6000;
            ddt =  0.0001;
           % [c_ap,c_am,kk,xx] = ref_two_limit(dt*N,ddt,K,epsi,L,lambda, kappa, c_p,c_m);  %--O(\eps) approximation
            [c_ap,c_am,c_ap3,c_am3,kk,xx] = ref_two_limit2(dt*N,ddt,K,epsi,L, lambda, kappa, kappa3,c_p,c_m,delta3);%--O(\eps^2) approximation
            for j=1:M
                if x(j)<=0
                    up_exact(j) = c_ap.'*exp(1i*kk*(x(j)-L))/K * exp(1i*(kappa*x(j) - omega*dt*N)/epsi);
                    um_exact(j) = c_am.'*exp(1i*kk*(x(j)-L))/K * exp(1i*(-kappa*x(j) - omega*dt*N)/epsi);
                     up3_exact(j) = c_ap3.'*exp(1i*kk*(x(j)-L))/K * exp(1i*(kappa3*x(j) - omega3*dt*N)/epsi);
                     um3_exact(j) = c_am3.'*exp(1i*kk*(x(j)-L))/K * exp(1i*(-kappa3*x(j) - omega3*dt*N)/epsi);
                else
                    up_exact(j) = c_ap.'*exp(1i*kk*(x(j)+L))/K * exp(1i*(kappa*x(j) - omega*dt*N)/epsi);
                    um_exact(j) = c_am.'*exp(1i*kk*(x(j)+L))/K * exp(1i*(-kappa*x(j) - omega*dt*N)/epsi);
                     up3_exact(j) = c_ap3.'*exp(1i*kk*(x(j)-L))/K * exp(1i*(kappa3*x(j) - omega3*dt*N)/epsi);
                     um3_exact(j) = c_am3.'*exp(1i*kk*(x(j)-L))/K * exp(1i*(-kappa3*x(j) - omega3*dt*N)/epsi);
                end
            end
             wp3 = (epsi * lambda / delta3) * up_exact.* conj(um_exact).*up_exact;
             wm3 = (epsi * lambda / delta3) * um_exact.* conj(up_exact).*um_exact;
            u_exact = up_exact + um_exact + up3_exact + um3_exact + wp3 + wm3;
        end
        
        coe2 = 1i*epsi*dt / dx^2;
        coe3 = -1i*2*dt*lambda;  
       
       if dx^2  <= 5*epsi^5
           c = 1;
       else
           c = 0;
       end

        %-------initial value-------
        up_old = ap0(x) .* exp(1i * kappa * x / epsi);  %
        um_old = am0(x) .* exp(-1i * kappa * x / epsi);  %
        wp3_old = (1-c)*(epsi * lambda / delta3) * up_old.* conj(um_old).*up_old;
        wm3_old = (1-c)*(epsi * lambda / delta3) * um_old.* conj(up_old).*um_old;
        up3_old = -wp3_old;
        um3_old = -wm3_old;
        
        %---------starting value-----------  
        up_old_right  = circshift(up_old, -1);   % u(j+1)
        up_old_left = circshift(up_old, 1);    % u(j-1)
        up3_old_right  = circshift(up3_old, -1);   % u(j+1)
        up3_old_left = circshift(up3_old, 1);    % u(j-1)
        
        um_old_right  = circshift(um_old, -1);   % u(j+1)
        um_old_left = circshift(um_old, 1);    % u(j-1)
        um3_old_right  = circshift(um3_old, -1);   % u(j+1)
        um3_old_left = circshift(um3_old, 1);    % u(j-1)
        
        laplacian_up_old = exp(-1i*beta)*(1+1i*beta) * up_old_right - 2 *up_old + exp(+1i*beta)*(1-1i*beta) * up_old_left;
        laplacian_um_old = exp(+1i*beta)*(1-1i*beta) * um_old_right - 2 *um_old + exp(-1i*beta)*(1+1i*beta) * um_old_left;
        laplacian_up3_old = exp(-1i*beta3)*(1+1i*beta3) * up3_old_right - 2 *up3_old + exp(+1i*beta3)*(1-1i*beta3) * up3_old_left;
        laplacian_um3_old = exp(+1i*beta3)*(1-1i*beta3) * um3_old_right - 2 *um3_old + exp(-1i*beta3)*(1+1i*beta3) * um3_old_left;
        
        nonlinear_up_old = (abs(up_old).^2+2*abs(um_old).^2) .* up_old + c*(conj(um_old).*up_old).*up_old +...
                            +2*um_old.*conj(up_old).*wp3_old + um_old.*conj(wm3_old).*um_old ;
        nonlinear_um_old = (abs(um_old).^2+2*abs(up_old).^2) .* um_old + c*(conj(up_old).*um_old).*um_old +...
                            +2*up_old.*conj(um_old).*wm3_old + up_old.*conj(wp3_old).*up_old ;
                        
        nonlinear_up3_old = 2*(abs(up_old).^2+abs(um_old).^2) .* up3_old;
        nonlinear_um3_old = 2*(abs(um_old).^2+abs(up_old).^2) .* um3_old;
                        
        up = exp(-1i*alpha)* (up_old + coe2/2 * laplacian_up_old + coe3/2 * nonlinear_up_old);
        um = exp(-1i*alpha)* (um_old + coe2/2 * laplacian_um_old + coe3/2 * nonlinear_um_old);
        
        up3 = exp(-1i*alpha3)* (up3_old + coe2/2 * laplacian_up3_old + coe3/2 * nonlinear_up3_old);
        um3 = exp(-1i*alpha3)* (um3_old + coe2/2 * laplacian_um3_old + coe3/2 * nonlinear_um3_old);

        %---------------update------------
        for n = 1:N-1
            wp3 = (1-c)*(epsi * lambda / delta3) * up.*conj(um).*up;
            wm3 = (1-c)*(epsi * lambda / delta3) * um.*conj(up).*um;
            % Periodic boundary handling with circular shift
            up_right  = circshift(up, -1);   % u(j+1)
            up_left = circshift(up, 1);    % u(j-1)
            up3_right  = circshift(up3, -1);   % u(j+1)
            up3_left = circshift(up3, 1);    % u(j-1)
            
            um_right  = circshift(um, -1);   % u(j+1)
            um_left = circshift(um, 1);    % u(j-1)
            um3_right  = circshift(um3, -1);   % u(j+1)
            um3_left = circshift(um3, 1);    % u(j-1)
 
            laplacian_up = exp(-1i*beta)*(1+1i*beta) * up_right - 2*up + exp(+1i*beta)*(1-1i*beta) * up_left;
            laplacian_um = exp(+1i*beta)*(1-1i*beta) * um_right - 2*um + exp(-1i*beta)*(1+1i*beta) * um_left;
            laplacian_up3 = exp(-1i*beta3)*(1+1i*beta3) * up3_right - 2*up3 + exp(+1i*beta3)*(1-1i*beta3) * up3_left;
            laplacian_um3 = exp(+1i*beta3)*(1-1i*beta3) * um3_right - 2*um3 + exp(-1i*beta3)*(1+1i*beta3) * um3_left;
            
            nonlinear_up = (abs(up).^2+2*abs(um).^2) .* up + c*(conj(um).*up).*up + 2*um.*conj(up).*wp3 + um.*conj(wm3).*um;
            nonlinear_um = (abs(um).^2+2*abs(up).^2) .* um + c*(conj(up).*um).*um + 2*up.*conj(um).*wm3 + up.*conj(wp3).*up ;
            nonlinear_up3 = 2*(abs(up).^2+abs(um).^2) .* up3;
            nonlinear_um3 = 2*(abs(um).^2+abs(up).^2) .* um3;
            
            up_new = exp(-1i*alpha)* (exp(-1i*alpha)*up_old + coe2 * laplacian_up + coe3 * nonlinear_up);
            um_new = exp(-1i*alpha)* (exp(-1i*alpha)*um_old + coe2 * laplacian_um + coe3 * nonlinear_um);
            up3_new = exp(-1i*alpha3)* (exp(-1i*alpha3)*up3_old + coe2 * laplacian_up3 + coe3 * nonlinear_up3);
            um3_new = exp(-1i*alpha3)* (exp(-1i*alpha3)*um3_old + coe2 * laplacian_um3 + coe3 * nonlinear_um3);
            
            % Update for next iteration
            up_old = up;
            up = up_new;
            up3_old = up3;
            up3 = up3_new;
            
            um_old = um;
            um = um_new;
            um3_old = um3;
            um3 = um3_new;
        end
        wp3 = (1-c)*(epsi * lambda / delta3) * up.*conj(um).*up;
        wm3 = (1-c)*(epsi * lambda / delta3) * um.*conj(up).*um;
        u = up + um + up3 + um3 + wp3 + wm3;
        err(i) = max(abs(u-u_exact));
        ep(i) = epsi;
        time(i) = dt;    
    end
    figure(1)
    subplot(1,2,1)
    loglog(ep, err,'+-')
    hold on
    subplot(1,2,2)
    loglog(ep,time,'+-')
    hold on

end

