clear
clc
%---Extended Crank-Nicolson algorithm---
%---up->u_1; um->u_{-1}; 
%---up3->w^*_3; um3->w^*_{-3}; 
%---wp3->w_3; wm3->w_{-3};

T = 0.5;
L = 6;
lambda = 1;

kappa = 1;
c_p = 1/2;
c_m = 1/2;

space = [0.4;0.2;0.1;0.05;0.025];
ind = [10^(-6);10^(-5);10^(-4);10^(-3);10^(-2);0.03;0.11;0.3;0.5;1];%%

ap0 = @(x) c_p*exp(-x.^2); %initial envelope ------
am0 = @(x) c_m*exp(-x.^2);
tol = 10^(-10);

omega = kappa^2/2;
kappa3 = 3*kappa;
omega3 = kappa3^2/2;
delta3 = -4*kappa^2;

err = zeros(length(ind),1);
ep = zeros(length(ind),1);
time = zeros(length(ind),1);

for loop=1:1
    dx = space(loop);
    for i=1:length(ind)
        epsi = ind(i);
        beta = kappa*dx/epsi;
        beta3 = kappa3*dx/epsi;
        dt = dx/2;
        alpha = omega*dt/epsi;
        alpha3 = omega3*dt/epsi; 
        
        %---------------------------------------------------
        M = floor(2*L/dx);
        x = (-L:dx:L-dx)';
        
        N = ceil(T/dt/2);
        %up = zeros(M,1);
        up_new = zeros(M,1);
        up_exact = zeros(M,1);
        up3_exact = zeros(M,1);
       % um = zeros(M,1);
        um_new = zeros(M,1);
        um_exact = zeros(M,1);
        um3_exact = zeros(M,1);
        u_exact = zeros(M,1);
       
        if epsi>10^(-3)
            %---------------reference solution (original equaion) for epsi=1------------------
            K = 6000;
            ddt = min(10^(-4),epsi/10);
            [c_u,kk,xx] =  ref(dt*N*2,ddt,K,epsi,L, lambda, kappa,c_p,c_m);
            
            for j=1:M
                if x(j)<=0
                    u_exact(j) = c_u.'*exp(1i*kk*(x(j)-L))/K;
                else
                    u_exact(j) = c_u.'*exp(1i*kk*(x(j)+L))/K;
                end
            end
        else
            %----reference solution---
            K = 6000;
            ddt =  0.0001;
 %           [c_ap,c_am,kk,xx] = ref_two_limit(dt*N*2,ddt,K,epsi,L,lambda, kappa, c_p,c_m);  %--O(\eps) approximation
             [c_ap,c_am,c_ap3,c_am3,kk,xx] = ref_two_limit2(dt*N*2,ddt,K,epsi,L, lambda, kappa, kappa3,c_p,c_m,delta3);%--O(\eps^2) approximation
            for j=1:M
                if x(j)<=0
                    up_exact(j) = c_ap.'*exp(1i*kk*(x(j)-L))/K * exp(1i*(kappa*x(j) - omega*dt*N*2)/epsi);
                    um_exact(j) = c_am.'*exp(1i*kk*(x(j)-L))/K * exp(1i*(-kappa*x(j) - omega*dt*N*2)/epsi);
                    up3_exact(j) = c_ap3.'*exp(1i*kk*(x(j)-L))/K * exp(1i*(kappa3*x(j) - omega3*dt*N*2)/epsi);
                    um3_exact(j) = c_am3.'*exp(1i*kk*(x(j)-L))/K * exp(1i*(-kappa3*x(j) - omega3*dt*N*2)/epsi);
                else
                    up_exact(j) = c_ap.'*exp(1i*kk*(x(j)+L))/K * exp(1i*(kappa*x(j) - omega*dt*N*2)/epsi);
                    um_exact(j) = c_am.'*exp(1i*kk*(x(j)+L))/K * exp(1i*(-kappa*x(j) - omega*dt*N*2)/epsi);
                    up3_exact(j) = c_ap3.'*exp(1i*kk*(x(j)-L))/K * exp(1i*(kappa3*x(j) - omega3*dt*N*2)/epsi);
                    um3_exact(j) = c_am3.'*exp(1i*kk*(x(j)-L))/K * exp(1i*(-kappa3*x(j) - omega3*dt*N*2)/epsi);
                end
            end
            wp3 = (epsi * lambda / delta3) * up_exact.* conj(um_exact).*up_exact;
            wm3 = (epsi * lambda / delta3) * um_exact.* conj(up_exact).*um_exact;
            u_exact = up_exact + um_exact + up3_exact + um3_exact + wp3 + wm3;
        end
        
        coe1 = 1i*dt*epsi/dx^2/2;
        coe2 = 2*1i*lambda*dt;
        
        Mat1_up_column = zeros(M,1);
        Mat1_up_column(1) = 1+2*coe1;
        Mat1_up_column(2) = -coe1*exp(1i*beta)*(1-1i*beta);
        Mat1_up_column(M) = -coe1*exp(-1i*beta)*(1+1i*beta); 
        Mat2_up = diag(repmat(1-2*coe1,1,M))+diag(repmat(coe1*exp(-1i*beta)*(1+1i*beta),1,M-1),1)+diag(repmat(coe1*exp(1i*beta)*(1-1i*beta),1,M-1),-1); 
        Mat2_up(1,M) = coe1*exp(1i*beta)*(1-1i*beta);
        Mat2_up(M,1) = coe1*exp(-1i*beta)*(1+1i*beta);
        
        Mat1_up3_column = zeros(M,1);
        Mat1_up3_column(1) = 1+2*coe1;
        Mat1_up3_column(2) = -coe1*exp(1i*beta3)*(1-1i*beta3);
        Mat1_up3_column(M) = -coe1*exp(-1i*beta3)*(1+1i*beta3); 
        Mat2_up3 = diag(repmat(1-2*coe1,1,M))+diag(repmat(coe1*exp(-1i*beta3)*(1+1i*beta3),1,M-1),1)+diag(repmat(coe1*exp(1i*beta3)*(1-1i*beta3),1,M-1),-1); 
        Mat2_up3(1,M) = coe1*exp(1i*beta3)*(1-1i*beta3);
        Mat2_up3(M,1) = coe1*exp(-1i*beta3)*(1+1i*beta3);
        
        %----coefficients for u_{-1}------
        beta_m = -beta;
        Mat1_um_column = zeros(M,1);
        Mat1_um_column(1) = 1+2*coe1;
        Mat1_um_column(2) = -coe1*exp(1i*beta_m)*(1-1i*beta_m);
        Mat1_um_column(M) = -coe1*exp(-1i*beta_m)*(1+1i*beta_m);
        
        Mat2_um = diag(repmat(1-2*coe1,1,M))+diag(repmat(coe1*exp(-1i*beta_m)*(1+1i*beta_m),1,M-1),1)+diag(repmat(coe1*exp(1i*beta_m)*(1-1i*beta_m),1,M-1),-1);
        Mat2_um(1,M) = coe1*exp(1i*beta_m)*(1-1i*beta_m);
        Mat2_um(M,1) = coe1*exp(-1i*beta_m)*(1+1i*beta_m);
        
        beta_m3 = -beta3;
        Mat1_um3_column = zeros(M,1);
        Mat1_um3_column(1) = 1+2*coe1;
        Mat1_um3_column(2) = -coe1*exp(1i*beta_m3)*(1-1i*beta_m3);
        Mat1_um3_column(M) = -coe1*exp(-1i*beta_m3)*(1+1i*beta_m3);
        
        Mat2_um3 = diag(repmat(1-2*coe1,1,M))+diag(repmat(coe1*exp(-1i*beta_m3)*(1+1i*beta_m3),1,M-1),1)+diag(repmat(coe1*exp(1i*beta_m3)*(1-1i*beta_m3),1,M-1),-1);
        Mat2_um3(1,M) = coe1*exp(1i*beta_m3)*(1-1i*beta_m3);
        Mat2_um3(M,1) = coe1*exp(-1i*beta_m3)*(1+1i*beta_m3);

        %---------------update------------
        mat1_up_eigenvalue = fft(Mat1_up_column);
        mat1_um_eigenvalue = fft(Mat1_um_column);
        mat1_up3_eigenvalue = fft(Mat1_up3_column);
        mat1_um3_eigenvalue = fft(Mat1_um3_column);
       if dx^2  <= 5*epsi^5
           c = 1;
       else
           c = 0;
       end
       
       %--------initial data---------
               
        up_old = ap0(x) .* exp(1i * kappa * x / epsi);  %
        um_old = am0(x) .* exp(-1i * kappa * x / epsi);  %
        wp3_old = (1-c)*(epsi * lambda / delta3) * up_old.* conj(um_old).*up_old;
        wm3_old = (1-c)*(epsi * lambda / delta3) * um_old.* conj(up_old).*um_old;
        up3_old = -wp3_old;
        um3_old = -wm3_old;
        
        up_iter = up_old; %inital
        um_iter = um_old; %inital
        up3_iter = up3_old; %inital
        um3_iter = um3_old; %inital
        wp3_iter = wp3_old; %inital
        wm3_iter = wm3_old; %inital
        
        for n = 1:N
            error = 1;
            while error > tol
                up_average = (exp(-1i*alpha)*up_old + exp(1i*alpha)*up_iter)/2;
                um_average = (exp(-1i*alpha)*um_old + exp(1i*alpha)*um_iter)/2;
                up3_average = (exp(-1i*alpha3)*up3_old + exp(1i*alpha3)*up3_iter)/2;
                um3_average = (exp(-1i*alpha3)*um3_old + exp(1i*alpha3)*um3_iter)/2;
                wp3_average = (exp(-1i*alpha3)*wp3_old + exp(1i*alpha3)*wp3_iter)/2;
                wm3_average = (exp(-1i*alpha3)*wm3_old + exp(1i*alpha3)*wm3_iter)/2;
                
                nonlinear_up = ((abs(up_old).^2 + abs(up_iter).^2)/2 + abs(um_old).^2+abs(um_iter).^2 ...
                                + c*(conj(um_average).*up_average)).* up_average...
                                + 2*(um_average).*conj(up_average).*wp3_average+(um_average).*conj(wm3_average).*um_average;  
                nonlinear_um = ((abs(um_old).^2 + abs(um_iter).^2)/2 + abs(up_old).^2+abs(up_iter).^2 ...
                                + c*(conj(up_average).*um_average)).* um_average...
                                + 2*(up_average).*conj(um_average).*wm3_average+(up_average).*conj(wp3_average).*up_average; 
                nonlinear_up3 = (abs(up_old).^2 + abs(up_iter).^2 + abs(um_old).^2 + abs(um_iter).^2).*up3_average;  
                nonlinear_um3 = (abs(um_old).^2 + abs(um_iter).^2 + abs(up_old).^2 + abs(up_iter).^2).*um3_average;              
                
                rhs_up_fft = fft(exp(-2*1i*alpha)*Mat2_up*up_old - exp(-1i*alpha)*coe2*nonlinear_up);
                rhs_um_fft = fft(exp(-2*1i*alpha)*Mat2_um*um_old - exp(-1i*alpha)*coe2*nonlinear_um);
                rhs_up3_fft = fft(exp(-2*1i*alpha3)*Mat2_up3*up3_old - exp(-1i*alpha3)*coe2*nonlinear_up3);
                rhs_um3_fft = fft(exp(-2*1i*alpha3)*Mat2_um3*um3_old - exp(-1i*alpha3)*coe2*nonlinear_um3);
                
                up_fft = rhs_up_fft ./ mat1_up_eigenvalue;
                um_fft = rhs_um_fft ./ mat1_um_eigenvalue;
                up3_fft = rhs_up3_fft ./ mat1_up3_eigenvalue;
                um3_fft = rhs_um3_fft ./ mat1_um3_eigenvalue;
                
                up_new = ifft(up_fft);
                um_new = ifft(um_fft);
                up3_new = ifft(up3_fft);
                um3_new = ifft(um3_fft);
                wp3_new = (1-c)*(epsi * lambda / delta3) * up_new.*conj(um_new).*up_new;
                wm3_new = (1-c)*(epsi * lambda / delta3) * um_new.*conj(up_new).*um_new;
                error = max(abs([up_new;um_new;up3_new;um3_new;wp3_new;wm3_new] - [up_iter;um_iter;up3_iter;um3_iter;wp3_new;wm3_new]));

                up_iter = up_new;
                um_iter = um_new;
                up3_iter = up3_new;
                um3_iter = um3_new;
                wp3_iter = wp3_new;
                wm3_iter = wm3_new;
            end
            up_iter = 2*up_new-up_old;
            um_iter = 2*um_new-um_old;
            up3_iter = 2*up3_new-up3_old;
            um3_iter = 2*um3_new-um3_old;
            wp3_iter = 2*wp3_new-wp3_old;
            wm3_iter = 2*wm3_new-wm3_old;
            up_old = up_new;
            um_old = um_new;
            up3_old = up3_new;
            um3_old = um3_new;
            wp3_old = wp3_new;
            wm3_old = wm3_new;
        end
        u = up_old + um_old + up3_old + um3_old + wp3_old + wm3_old;
        err(i) = max(abs(u-u_exact));
        ep(i) = epsi;
        time(i) = dt;
        
    end
    figure(1)
    subplot(1,2,1)
    loglog(ep, err,'+-')
    hold on
    subplot(1,2,2)
    loglog(ep,time,'+-')
    hold on
end

