function [c_ap,c_am,c_ap3,c_am3,kk,x] = ref_two_limit2(T,dt,K,epsi,L, lambda, kappa, kappa3,cp,cm,rho)
%----time-------
N = round(T/dt);
%-------space--------
dx = 2*L/K;
x = (-L:dx:L-dx)';

%-----initial value------
ap0 = cp*exp(-x.^2);
am0 = cm*exp(-x.^2);
bp0 = (epsi*lambda/rho) * ap0 .* conj(am0) .* ap0;
bm0 = (epsi*lambda/rho) * am0 .* conj(ap0) .* am0;
ap30 = -bp0;
am30 = -bm0;

kk = (2*pi/(2*L)) * [0:K/2-1, -K/2:-1]';
Ma_ap = exp(-1i * (kappa * kk+ epsi/2 * kk.^2) * dt/2);  % linear half-step operator
Ma_am = exp(-1i * (-kappa * kk+ epsi/2 * kk.^2) * dt/2);  % linear half-step operator
Ma_ap3 = exp(-1i * (kappa3 * kk+ epsi/2 * kk.^2) * dt/2);  % linear half-step operator
Ma_am3 = exp(-1i * (-kappa3 * kk+ epsi/2 * kk.^2) * dt/2);  % linear half-step operator

c_ap = fft(ap0);
c_am = fft(am0);
c_ap3 = fft(ap30);
c_am3 = fft(am30);

% Dealiasing mask (2/3 rule)
cutoff = floor(K/3);
dealias_mask = ones(K,1);
dealias_mask(cutoff+1:K-cutoff) = 0;

for n=1:N
    % Linear half step
    c_ap = Ma_ap .* c_ap;
    c_am = Ma_am .* c_am;
    c_ap3 = Ma_ap3 .* c_ap3;
    c_am3 = Ma_am3 .* c_am3;
    % Transform to physical space
    ap_phys = ifft(c_ap);
    am_phys = ifft(c_am);
    ap3_phys = ifft(c_ap3);
    am3_phys = ifft(c_am3);
    bp_phys = (epsi * lambda / rho) * ap_phys .* conj(am_phys) .* ap_phys;
    bm_phys = (epsi * lambda / rho) * am_phys .* conj(ap_phys) .* am_phys;
    % Nonlinear full step
    % Nonlinear terms in physical space:
    % a_+1
    NL_ap = ((abs(ap_phys).^2 + 2*abs(am_phys).^2) .* ap_phys) ...
            + 2 * am_phys .* conj(ap_phys) .* ap3_phys ...
            + (am_phys.^2) .* conj(bm_phys);
    % a_-1
    NL_am = ((abs(am_phys).^2 + 2*abs(ap_phys).^2) .* am_phys) ...
            + 2 * ap_phys .* conj(am_phys) .* am3_phys ...
            + (ap_phys.^2) .* conj(bp_phys);
        
    cNL_ap = fft(NL_ap).* dealias_mask;
    cNL_am = fft(NL_am).* dealias_mask;
    c_ap = c_ap - 1i * lambda * dt * cNL_ap;
    c_am = c_am - 1i * lambda * dt * cNL_am;
    
    NL_ap3 = 2 * (abs(ap_phys).^2 + abs(am_phys).^2);
    NL_am3 = 2 * (abs(am_phys).^2 + abs(ap_phys).^2);
    ap3_phys = exp(-1i * lambda * NL_ap3 * dt) .* ap3_phys;
    am3_phys = exp(-1i * lambda * NL_am3 * dt) .* am3_phys;
    
    % Transform back to Fourier space
    c_ap3 = fft(ap3_phys);
    c_am3 = fft(am3_phys);
    
    % Linear half step
    c_ap = Ma_ap .* c_ap;
    c_am = Ma_am .* c_am;
    c_ap3 = Ma_ap3 .* c_ap3;
    c_am3 = Ma_am3 .* c_am3;
end
% Return Fourier coefficients and spatial grid
end
