function [c_a,c_b,kk,x] = ref_two_limit(T,dt,K,epsi,L, lambda, kappa,ca,cb)
%----time-------
N = round(T/dt);
%-------space--------
dx = 2*L/K;
x = (-L:dx:L-dx)';

%-----initial value------
a0 = ca*exp(-x.^2);
b0 = cb*exp(-x.^2);

kk = (2*pi/(2*L)) * [0:K/2-1, -K/2:-1]';
Ma_a = exp(-1i * (kappa * kk+ epsi/2 * kk.^2) * dt/2);  % linear half-step operator
Ma_b = exp(-1i * (-kappa * kk+ epsi/2 * kk.^2) * dt/2);  % linear half-step operator

c_a = fft(a0);
c_b = fft(b0);

for n=1:N
    % Linear half step
    c_a = Ma_a .* c_a;
    c_b = Ma_b .* c_b;
    
    % Transform to physical space
    a_phys = ifft(c_a);
    b_phys = ifft(c_b);
    
    % Nonlinear full step
    % Nonlinear step with predictor-corrector
    NL_a = abs(a_phys).^2 + 2 * abs(b_phys).^2;
    NL_b = abs(b_phys).^2 + 2 * abs(a_phys).^2;
    
    % Predictor step
    a_pred = exp(-1i * lambda * NL_a * dt) .* a_phys;
    b_pred = exp(-1i * lambda * NL_b * dt) .* b_phys;
    
    % Recompute NL with predicted values
    NL_a_new = abs(a_pred).^2 + 2 * abs(b_pred).^2;
    NL_b_new = abs(b_pred).^2 + 2 * abs(a_pred).^2;
    
    % Corrector step (average NL and NL_new)
    a_phys = exp(-1i * lambda * (NL_a + NL_a_new)/2 * dt) .* a_phys;
    b_phys = exp(-1i * lambda * (NL_b + NL_b_new)/2 * dt) .* b_phys;
    
    % Transform back to Fourier space
    c_a = fft(a_phys);
    c_b = fft(b_phys);
    
    % Linear half step
    c_a = Ma_a .* c_a;
    c_b = Ma_b .* c_b;
end

% Return Fourier coefficients and spatial grid
end
