function [c_u,kk,x] = ref(T,dt,K,epsi,L, lambda,kappa,ca,cb)
     %----time-------
    N = round(T/dt);
    %-------space--------

    dx = 2*L/K;
    x = (-L:dx:L-dx)';

    %-----initial value------
    %p = @(x,epsi) 
    u_p = ca*exp(-x.^2 + 1i*kappa.*x/epsi);
    u_m = cb*exp(-x.^2 - 1i*kappa.*x/epsi);
    u0 = u_p + u_m;
    kk = (2*pi/(2*L)) * [0:K/2-1, -K/2:-1]';
    A = kk.^2;
    Ma = exp(-1i*epsi/2*A*dt/2);
    c_u = fft(u0);
    for n=1:N
        %---------exact for linear---------
        c_u = Ma.*c_u;
        y = ifft(c_u);
        %---exact for nonlinear---
        z = exp(-1i*lambda*(abs(y).^2)*dt).*y;  %y.*conj(y)
        c2 = fft(z);
        %----------exact for nonlinear-------
        c_u = Ma.*c2;
        %u = ifft(c_u);
    end
end


