function [c_a,kk,x] = ref(T,dt,K,epsi,L, lambda,kappa,ca)
     %----time-------
    N = round(T/dt);
    %-------space--------

    dx = 2*L/K;
    x = (-L:dx:L-dx)';
    
    a0 = ca*exp(-x.^2);
    kk = (2*pi/(2*L)) * [0:K/2-1, -K/2:-1]';
   % A = kk.^2;
   % Ma = exp(-1i*epsi/2*A*dt/2);
    Ma = exp(-1i * (kappa * kk+ epsi/2 * kk.^2) * dt/2);
    c_a = fft(a0);
    for n=1:N
        %---------exact for linear---------
        c_a = Ma.*c_a;
        y = ifft(c_a);
        %---exact for nonlinear---
        z = exp(-1i*lambda*(abs(y).^2)*dt).*y;  %y.*conj(y)
        c2 = fft(z);
        %----------exact for nonlinear-------
        c_a = Ma.*c2;
        %u = ifft(c_u);
    end
    
    
    
    
    %-----initial value------
    %p = @(x,epsi) 
%     u0 = ca*exp(-x.^2 + 1i*kappa_a.*x/epsi)+cb*exp(-x.^2 + 1i*kappa_b.*x/epsi);
%     kk = (2*pi/(2*L)) * [0:K/2-1, -K/2:-1]';
%     A = kk.^2;
%     Ma = exp(-1i*epsi/2*A*dt/2);
%     c_u = fft(u0);
%     for n=1:N
%         %---------exact for linear---------
%         c_u = Ma.*c_u;
%         y = ifft(c_u);
%         %---exact for nonlinear---
%         z = exp(-1i*lambda*(abs(y).^2)*dt).*y;  %y.*conj(y)
%         c2 = fft(z);
%         %----------exact for nonlinear-------
%         c_u = Ma.*c2;
%         %u = ifft(c_u);
%     end
end


