clear
clc

T = 0.5;
L = 6;
lambda = 1;
kappa = 1;
omega = kappa^2/2;

ca = 1;
a0 = @(x) ca*exp(-x^2); %initial envelope------
p = @(x,epsi) ca*exp(-x.^2+1i*kappa*x/epsi); %initial value------

space = [0.4;0.2;0.1;0.05;0.025];
ind = [10^(-6);10^(-5);10^(-4);10^(-3);10^(-2);0.03;0.1;0.3;1];

err = zeros(length(ind),1);
ep = zeros(length(ind),1);
time = zeros(length(ind),1);
for loop=1:1 %length(space)
    dx = space(loop);
    for i=1:length(ind)
        epsi = ind(i);
        beta = kappa*dx/epsi;
        gamma = 1+max(abs(beta),1);
        dt = min(dx/2,dx^2/(2*epsi*gamma));
        alpha = omega*dt/epsi;

        %---------------------------------------------------

        M = floor(2*L/dx);
        x = (-L:dx:L-dx)';

        N = ceil(T/dt);
        u_new = zeros(M,1);
        u_exact = zeros(M,1);

        u_old = p(x,epsi);
  

        if epsi >= 10^(-3)
            %---------------reference solution (original equaion) for epsi=1------------------
             K = 6000;
             ddt = min(10^(-4),epsi/100);
            [c_a,kk,xx] =  ref(dt*N,ddt,K,epsi,L, lambda, kappa,ca);
            for j=1:M
                if x(j)<=0
                    u_exact(j) = c_a.'*exp(1i*kk*(x(j)-L))/K * exp(1i*(kappa*x(j) - omega*dt*N)/epsi);
                else
                    u_exact(j) = c_a.'*exp(1i*kk*(x(j)+L))/K * exp(1i*(kappa*x(j) - omega*dt*N)/epsi);
                end
            end
        else
            %---------------reference solution (limit eqaution)------------------
            for j=1:M
                an = a0(x(j)-kappa*dt*N);
                u_exact(j) = an*exp(-1i*lambda*norm(an)^2*dt*N)*exp(1i*(kappa*x(j)-kappa^2*dt*N/2)/epsi);
            end
        end
        
        coe2 = 1i*epsi*dt / dx^2;
        coe3 = -1i*2*dt*lambda;
        
        %--------starting value----------
        u_old_plus  = circshift(u_old, -1);   
        u_old_minus = circshift(u_old, 1);    

        laplacian_old = exp(-1i*beta)*(1+1i*beta) * u_old_plus - 2 *u_old + exp(1i*beta)*(1-1i*beta) * u_old_minus;
        nonlinear_old = abs(u_old).^2 .* u_old;

        u = exp(-1i*alpha)* (u_old + coe2/2 * laplacian_old + coe3/2 * nonlinear_old);

        %---------------update------------
        for n = 1:N-1
            % Periodic boundary handling with circular shift
            u_plus  = circshift(u, -1);   % u(j+1)
            u_minus = circshift(u, 1);    % u(j-1)

            laplacian = exp(-1i*beta)*(1+1i*beta) * u_plus - 2 *u + exp(1i*beta)*(1-1i*beta) * u_minus;
            nonlinear = abs(u).^2 .* u;

            u_new = exp(-1i*alpha)* (exp(-1i*alpha)*u_old + coe2 * laplacian + coe3 * nonlinear);

            % Update for next iteration
            u_old = u;
            u = u_new;
        end
        
        err(i) = max(abs(u-u_exact));
        ep(i) = epsi;
        time(i) = dt;

    end
    figure(1)
    subplot(1,2,1)
    loglog(ep, err,'+-')
    hold on
    subplot(1,2,2)
    loglog(ep,time,'+-')
    hold on
end





