clear
clc

T = 0.5;
L = 6;
lambda = 1;
kappa = 1;
omega = kappa^2/2;

ca = 1;
a0 = @(x) ca*exp(-x^2); %initial envelope------
p = @(x,epsi) exp(-x.^2+1i*kappa*x/epsi); %initial value------

space = [0.4;0.2;0.1;0.05;0.025];%[0.6;0.3;0.15;0.075;0.0325];
ind = [10^(-6);10^(-5);10^(-4);10^(-3);10^(-2);0.03;0.1;0.3;1];
tol = 10^(-10);

err = zeros(length(ind),1);
ep = zeros(length(ind),1);
time = zeros(length(ind),1);

for loop=1:1 %length(space)
    dx = space(loop);
    for i=1:length(ind)
        ep0 = ind(i);
        epsi = ep0;
        beta = kappa*dx/epsi;
        dt = dx/2;
        alpha = kappa^2*dt/2/epsi;
        %---------------------------------------------------
        M = floor(2*L/dx);
        x = (-L:dx:L-dx)';

        N = ceil(T/dt/2);
        u_new = zeros(M,1);
        u_exact= zeros(M,1);
        f = zeros(M,1);

        u_old = p(x,epsi);

        if epsi >= 10^(-3)
            %---------------reference solution (original equaion) for epsi=1------------------
            K = max(6000,10*epsi);
            ddt = min(10^(-4),epsi/100);
            [c_a,kk,xx] =  ref(dt*N*2,ddt,K,epsi,L, lambda, kappa,ca);
            for j=1:M
                if x(j)<=0
                    u_exact(j) = c_a.'*exp(1i*kk*(x(j)-L))/K * exp(1i*(kappa*x(j) - omega*dt*N*2)/epsi);
                else
                    u_exact(j) = c_a.'*exp(1i*kk*(x(j)+L))/K * exp(1i*(kappa*x(j) - omega*dt*N*2)/epsi);
                end
            end
        else
            %---------------reference solution (limit eqaution)------------------
            for j=1:M
                an = a0(x(j)-kappa*dt*N*2);
                u_exact(j) = an*exp(-1i*lambda*norm(an)^2*dt*N*2)*exp(1i*(kappa*x(j)-kappa^2*dt*N*2/2)/epsi);
            end
        end

        coe1 = 1i*dt*epsi/dx^2/2;
        coe2 = 1i*lambda*dt/2;
        
        mat1_column = zeros(M,1);
        mat1_column(1) = 1+2*coe1;
        mat1_column(2) = -coe1*exp(1i*beta)*(1-1i*beta);
        mat1_column(M) = -coe1*exp(-1i*beta)*(1+1i*beta);
        
        Mat2 = diag(repmat(1-2*coe1,1,M))+diag(repmat(coe1*exp(-1i*beta)*(1+1i*beta),1,M-1),1)+diag(repmat(coe1*exp(1i*beta)*(1-1i*beta),1,M-1),-1);
        
        Mat2(1,M) = coe1*exp(1i*beta)*(1-1i*beta);
        Mat2(M,1) = coe1*exp(-1i*beta)*(1+1i*beta);

        %---------------update------------
        mat1_eigenvalue = fft(mat1_column);
        u_iter = u_old; %inital
        for n = 1:N
            error = 1;
            while error > tol
%                 for j = 1:M
%                     f(j) = (norm(u_old(j))^2+norm(u_iter(j))^2)*(exp(-1i*alpha)*u_old(j)+exp(1i*alpha)*u_iter(j));
%                 end
                f = (abs(u_old).^2 + abs(u_iter).^2) .* (exp(-1i*alpha)*u_old + exp(1i*alpha)*u_iter);   
                rhs_fft = fft(exp(-2*1i*alpha)*Mat2*u_old - exp(-1i*alpha)*coe2*f);
                u_fft = rhs_fft ./ mat1_eigenvalue;
                u_new = ifft(u_fft);
                error = max(sqrt(real(u_new-u_iter).^2+imag(u_new-u_iter).^2));%norm(u_newnew-u_new);
                u_iter = u_new;
            end
           % u_iter = 2*u_new-u_old;
            u_old = u_new;
        end
        err(i) =  max(abs(u_old-u_exact));%/max(abs(u_exact));%max(sqrt(real(u_old-u_exact).^2+imag(u_old-u_exact).^2));
        ep(i) = epsi;
        time(i) = dt;
    end
    figure(1)
    subplot(1,2,1)
    loglog(ep, err,'+-')
    hold on
    subplot(1,2,2)
    loglog(ep,time,'+-')
    hold on
end





