# "Electric Field"

# from abc import ABC, abstractmethod
# import os
# import numpy as np
# from repscat.aux_funcs import get_k_list_gaussian
# from repscat.config import DATA_PATH
# import matplotlib.pyplot as plt


# class Info:
#     """Smallest information required to define a field representation."""

#     def __init__(self, field_name, basis_type, **kwargs):
#         self._check_input(kwargs)
#         self._field_name = field_name
#         self._basis_type = basis_type
#         self._parameters = kwargs
#         self._file_path = self._set_file_path()

#     @property
#     def field_name(self):
#         return self._field_name

#     @property
#     def basis_type(self):
#         return self._basis_type

#     @property
#     def parameters(self):
#         return self._parameters

#     @property
#     def file_path(self):
#         return self._file_path

#     def _set_file_path(self):
#         file_name = f"[{self._field_name}]"
#         file_name += f"_[{self._basis_type}]"
#         for parameter, value in self._parameters.items():
#             file_name += f"_[{parameter}]=[{value}]"
#         file_name += ".npy"

#         full_path = os.path.join(
#             DATA_PATH,
#             "fields",
#             file_name,
#         )
#         return full_path

#     def _check_input(self, kwargs):
#         """Input must be integers for correct loading and saving of files.
#         To do: extend to decimals.
#         """
#         # for i in kwargs:
#         #     if not isinstance(kwargs[i], (int, str)):
#         #         raise basis_typeError("Only integers")


# class Representation(ABC):
#     """Representation of a physical entity."""

#     def __init__(self, info, domain = None, vals = None):
#         self._check_info(info)
#         self._info = info
#         if domain is None:
#             self._domain = self._get_domain()
#         else:
#             self._domain = domain
#         if vals is None:
#             self._vals = self._get_vals()
#         else:
#             self._vals = vals

#     @property
#     def info(self):
#         return self._info

#     @property
#     def vals(self):
#         return self._vals
    
#     @vals.setter
#     def vals(self, arr):
#         self._vals = arr

#     @property
#     def domain(self):
#         return self._domain

#     def _get_vals(self):
#         # if os.path.isfile(self._info.file_path):
#         #     print("Loading representation values")
#         #     with open(self._info.file_path, "rb") as file:
#         #         return np.load(file)
#         # else:
#         # print("Computing representation values")
#         vals = self._compute_vals()
#         # with open(self._info.file_path, "wb") as f:
#         #     np.save(f, vals)
#         return vals

#     @abstractmethod
#     def _check_info(self, info):
#         """Info should correspond to the representation."""

#     @abstractmethod
#     def _compute_vals(self):
#         pass

#     @abstractmethod
#     def _get_domain(self):
#         """Should not duplicate info."""
#         pass
    
#     def plot(self, linestyle='-'):
#         if self._info.basis_type == "WF_AM":
#             max_jay = np.shape(self._vals)[2]
#             # print(self._domain['k_list'][0], self._domain['k_list'][-1])
#             plt.plot(self._domain['k_list'], self._vals[:,0,:,max_jay+1], linestyle=linestyle)
            
#     # def interpolate(k_list)


# class Adapter:

#     @staticmethod
#     def get_k_list_gaussian(info):
#         return get_k_list_gaussian(
#             info.parameters["center_wavelength"],
#             info.parameters["width_time"],
#             info.parameters["num_k"],
#         )
    
#     @staticmethod
#     def get_eta_list_gaussian(info):
#         if not {"center_wavelength", "width_time", "num_k"} <= set(info.parameters):
#             raise ValueError("Need more info")


    
# # class Field:
# #     """Electromagnetic field outside of the scatter.
# #     Contains  different representations, such as wave function coefficients in
# #     angular momentum basis or in plane wave basis.
# #     """

# #     def __init__(self, field_name):
# #         self._field_name = field_name
# #         self._representations = {}

# #     def add_representation(self, representation):
# #         """Adds a field representation to the field instance."""
# #         if representation.info.field_name != self._field_name:
# #             raise NameError("Representation does not correspond to the field")
# #         self._representations[
# #             representation.info.basis_type
# #         ] = representation  # FieldRepresentation(info)

# #     @property
# #     def representations(self):
# #         return self._representations
