

% Solve the linear problem
% (I-(c/epsi) \partial_{x_1} \mu^{-1} \partial_{x_1}) E2 = F

function out=solve_system_E2_1_ref(F,meshwxy,meshwz,c)


% Prepare grid ------------------------------------------------------------

xvec=(0:meshwxy:1)';
xxvec=xvec(1:end-1)+0.5*meshwxy;
xvec=xvec(2:end-1);

yvec=(0:meshwxy:1)';
yyvec=yvec(1:end-1)+0.5*meshwxy;
yvec=yvec(2:end-1);

zvec=(0:meshwz:1)';
zzvec=zvec(1:end-1)+0.5*meshwz;
zvec=zvec(2:end-1);

% -------------------------------------------------------------------------

N1=size(F,1);
N2=size(F,2);
N3=size(F,3);
out=zeros(size(F));
epsi=eval_epsilon(xvec,yyvec,zvec);
mu=eval_mu(xxvec,yyvec,zvec);

for n2=1:N2
    for n3=1:N3
        f=squeeze(F(:,n2,n3));
        epsiinv=1./squeeze(epsi(:,n2,n3));
        muinv=1./squeeze(mu(:,n2,n3));
        D=diag(muinv(2:end-1),1)+diag(muinv(2:end-1),-1) ...
            - diag( muinv(1:end-1)+muinv(2:end) );
        D=D/meshwxy^2;
        D=diag(epsiinv)*D;
        v=sparse(eye(N1,N1)-c*D)\f;
        
        out(:,n2,n3)=v;
    end
end


    
    
    


