

% Solve the linear problem
% (I-(c/epsi) \partial_{x_3} \mu^{-1} \partial_{x_3}) E1 = F

function out=solve_system_E1_3_ref(F,meshwxy,meshwz,c)


% Prepare grid ------------------------------------------------------------

xvec=(0:meshwxy:1)';
xxvec=xvec(1:end-1)+0.5*meshwxy;
xvec=xvec(2:end-1);

yvec=(0:meshwxy:1)';
yyvec=yvec(1:end-1)+0.5*meshwxy;
yvec=yvec(2:end-1);

zvec=(0:meshwz:1)';
zzvec=zvec(1:end-1)+0.5*meshwz;
zvec=zvec(2:end-1);

% -------------------------------------------------------------------------

N1=size(F,1);
N2=size(F,2);
N3=size(F,3);
out=zeros(size(F));
epsi=eval_epsilon(xxvec,yvec,zvec);
mu=eval_mu(xxvec,yvec,zzvec);

for n1=1:N1
    for n2=1:N2
        f=squeeze(F(n1,n2,:));
        epsiinv=1./squeeze(epsi(n1,n2,:));
        muinv=1./squeeze(mu(n1,n2,:));
        D=diag(muinv(2:end-1),1)+diag(muinv(2:end-1),-1) ...
            - diag( muinv(1:end-1)+muinv(2:end) );
        D=D/meshwz^2;
        D=diag(epsiinv)*D;
        v=sparse(eye(N3,N3)-c*D)\f;        

        out(n1,n2,:)=v;
    end
end


    
    
    


