


% Error plot --------------------------------------------------------------

fs=10;
lw=1;
ms1=6;
ms2=12;

% close all hidden

figure

loglog(hvec,errorfinal,'k.-','LineWidth',lw,'MarkerSize',ms2)
hold on
loglog(hvec,10*hvec.^2,'k--','LineWidth',lw)
loglog(hvec,(1/sqrt(10))*hvec.^1.5,'k-.','LineWidth',lw)
hold off
xlabel('step size','FontSize',fs)
ylabel('error','FontSize',fs)
ylim([1e-6,1e-2])
legend('Error','order 2','order 1.5','Location','SouthEast')
set(gca,'FontSize',fs)

set(gcf, 'PaperPositionMode', 'manual');
set(gcf, 'PaperUnits', 'centimeters');
set(gcf, 'PaperPosition', [1 1 12 8]);

print(gcf,'-depsc','figure2')

! epstopdf figure2.eps

