

clc; clear all hidden; close all hidden;

fprintf('\n\n\n')
fprintf('This program generates the plot shown in Figure 2 in \n\n')
fprintf('   CRC Preprint 2022/62: \n')
fprintf('   Analysis of a Peaceman–Rachford ADI scheme for \n')
fprintf('   Maxwell equations in heterogenous media \n') 
fprintf('   by Konstantin Zerulla and Tobias Jahnke.\n')
fprintf('\n\n')
fprintf('You have three options: \n\n')
fprintf('1. Run the entire simulation. This will require a lot of memory \n')
fprintf('   and a runtime of several days. \n\n')
fprintf('2. Make the figure using the data which we have computed. \n\n')
fprintf('3. Run a toy problem with a very coarse space discretization. \n')
fprintf('   The outcome is completely different from Figure 2 and not \n')
fprintf('   very useful per se.\n\n')

answer = input('Please enter 1, 2, or 3.   ');
        fprintf('\n')
switch answer
    case 1        
        adi_convergence_ref
    case 2
        load('data-cluster-fine-space.mat');
        plot_convergence;
    case 3
        adi_convergence_ref_toyproblem
    otherwise
        fprintf('+++++++++++++++++++++++++++++++++++++++++++++++++++++++ \n')
        fprintf('No valid option. Please try again and enter 1, 2, or 3. \n')
        fprintf('+++++++++++++++++++++++++++++++++++++++++++++++++++++++ \n\n\n')
end
fprinf('\n\n\n')



