


function [E1,E2,E3,H1,H2,H3] = initialdata_ref(mmaxy,mmaxz)

C1=1; C2=0; C3=0; 
[E1,E2,E3,H1,H2,H3] = eval_solution_ref(0,C1,C2,C3,mmaxy,mmaxz);

% In order to satisfy the divergence conditions, we have to divide by
% epsilon and mu, respectively:

meshwxy=1/mmaxy;
meshwz=1/mmaxz;

xvec=(0:meshwxy:1)';
xxvec=xvec(1:end-1)+0.5*meshwxy;
xvec=xvec(2:end-1);

yvec=(0:meshwxy:1)';
yyvec=yvec(1:end-1)+0.5*meshwxy;
yvec=yvec(2:end-1);

zvec=(0:meshwz:1)';
zzvec=zvec(1:end-1)+0.5*meshwz;
zvec=zvec(2:end-1);

epsi=eval_epsilon(xxvec,yvec,zvec); 
E1=E1./epsi;
epsi=eval_epsilon(xvec,yyvec,zvec); 
E2=E2./epsi;
epsi=eval_epsilon(xvec,yvec,zzvec); 
E3=E3./epsi;

mu=eval_mu(xvec,yyvec,zzvec); 
H1=H1./mu;
mu=eval_mu(xxvec,yvec,zzvec); 
H2=H2./mu;
mu=eval_mu(xxvec,yyvec,zvec); 
H3=H3./mu;
























