

function [E1,E2,E3,H1,H2,H3] = eval_solution_ref(t,C1,C2,C3,mmaxy,mmaxz)


% Prepare grid ------------------------------------------------------------

meshwxy=1/mmaxy;
meshwz=1/mmaxz;

xvec=(0:meshwxy:1)';
xxvec=xvec(1:end-1)+0.5*meshwxy;
xvec=xvec(2:end-1);

yvec=(0:meshwxy:1)';
yyvec=yvec(1:end-1)+0.5*meshwxy;
yvec=yvec(2:end-1);

zvec=(0:meshwz:1)';
zzvec=zvec(1:end-1)+0.5*meshwz;
zvec=zvec(2:end-1);


% Evaluate solution -------------------------------------------------------

E1=zeros(mmaxy,mmaxy-1,mmaxz-1);
E2=zeros(mmaxy-1,mmaxy,mmaxz-1);
E3=zeros(mmaxy-1,mmaxy-1,mmaxz);
H1=zeros(mmaxy-1,mmaxy,mmaxz);
H2=zeros(mmaxy,mmaxy-1,mmaxz);
H3=zeros(mmaxy,mmaxy,mmaxz-1);

% Solution type 1

C=C1;
for j=1:size(C,1)
    for k=1:size(C,2)
        if abs(C(j,k))>1e-10
            omega=pi*sqrt(j^2 + k^2);
            
            [X,Y,Z]=ndgrid(xxvec,yvec,zvec);
            E1 = E1 + C(j,k) * (X-0.5).*X.^2.*(X-1).^2.*(Y-0.5).^2.*sin(pi*Y).*sin(k*pi*Z)*cos(omega*t);
            
            [X,Y,Z]=ndgrid(xxvec,yvec,zzvec);
            H2 = H2 - C(j,k) * (pi*k/omega)*sin(j*pi*Y).*cos(k*pi*Z)*sin(omega*t);
            
            [X,Y,Z]=ndgrid(xxvec,yyvec,zvec);
            H3 = H3 + C(j,k) * (pi*j/omega)*cos(j*pi*Y).*sin(k*pi*Z)*sin(omega*t);
            
        end
    end
end


% Solution type 2

C=C2;
for j=1:size(C,1)
    for k=1:size(C,2)
        if abs(C(j,k))>1e-10
            omega=pi*sqrt(j^2 + k^2);
            
            [X,Y,Z]=ndgrid(xvec,yyvec,zvec);
            E2 = E2 + C(j,k) * sin(j*pi*X).*sin(k*pi*Z)*cos(omega*t);
            
            [X,Y,Z]=ndgrid(xvec,yyvec,zzvec);
            H1 = H1 + C(j,k) * (pi*k/omega)*sin(j*pi*X).*cos(k*pi*Z)*sin(omega*t);
            
            [X,Y,Z]=ndgrid(xxvec,yyvec,zvec);
            H3 = H3 - C(j,k) * (pi*j/omega)*cos(j*pi*X).*sin(k*pi*Z)*sin(omega*t);
            
        end
    end
end


% Solution type 3

C=C3;
for j=1:size(C,1)
    for k=1:size(C,2)
        if abs(C(j,k))>1e-10
            omega=pi*sqrt(j^2 + k^2);
            
            [X,Y,Z]=ndgrid(xvec,yvec,zzvec);
            E3 = E3 + C(j,k) * sin(j*pi*X).*sin(k*pi*Y)*cos(omega*t);
            
            [X,Y,Z]=ndgrid(xvec,yyvec,zzvec);
            H1 = H1 - C(j,k) * (pi*k/omega)*sin(j*pi*X).*cos(k*pi*Y)*sin(omega*t);
            
            [X,Y,Z]=ndgrid(xxvec,yvec,zzvec);
            H2 = H2 + C(j,k) * (pi*j/omega)*cos(j*pi*X).*sin(k*pi*Y)*sin(omega*t);
            
        end
    end
end




