


% Solve the 3d Maxwell equations with the ADI method


function [E1,E2,E3,H1,H2,H3,divEerror,divHerror,normL2] = adi_ref(E1,E2,E3,H1,H2,H3,mmaxxy,mmaxz,tend,N)

% Prepare grid ------------------------------------------------------------

meshwxy=1/mmaxxy;
meshwz=1/mmaxz;

xvec=(0:meshwxy:1)';
xxvec=xvec(1:end-1)+0.5*meshwxy;
xvec=xvec(2:end-1);

yvec=(0:meshwxy:1)';
yyvec=yvec(1:end-1)+0.5*meshwxy;
yvec=yvec(2:end-1);

zvec=(0:meshwz:1)';
zzvec=zvec(1:end-1)+0.5*meshwz;
zvec=zvec(2:end-1);

h=tend/N; tvec=0:h:tend;

fprintf('\n\n\n')
fprintf('Solve the 3d Maxwell equations with the ADI method. \n\n')
fprintf('Step-size: %g \n',h)
fprintf('%g steps \n\n',N)
% fprintf('Completed: ')




% ADI scheme --------------------------------------------------------------

% err=zeros(1,N);

% wb=waitbar(0,['Time integration with the ADI method (',num2str(N),' steps)']);
for n=1:N
    
    % waitbar(n/N,wb)
    
    % First half-step - - - - - - - - - - - - - - - - - - - - - - - - - - -
    
    % E1
    F=partialE_ref(E2,1,meshwxy,meshwz); 
    mu=eval_mu(xxvec,yyvec,zvec);
    F=F./mu;
    F=partialH_ref(F,2,meshwxy,meshwz);
    F=0.5*h*(partialH_ref(H3,2,meshwxy,meshwz)-partialH_ref(H2,3,meshwxy,meshwz))-0.25*h^2*F;
    epsi=eval_epsilon(xxvec,yvec,zvec);
    F=F./epsi;
    F=F+E1;    
    E1new=solve_system_E1_2_ref(F,meshwxy,meshwz,0.25*h^2);
    
    % E2
    F=partialE_ref(E3,2,meshwxy,meshwz); 
    mu=eval_mu(xvec,yyvec,zzvec);
    F=F./mu;
    F=partialH_ref(F,3,meshwxy,meshwz);
    F=0.5*h*(partialH_ref(H1,3,meshwxy,meshwz)-partialH_ref(H3,1,meshwxy,meshwz))-0.25*h^2*F;
    epsi=eval_epsilon(xvec,yyvec,zvec);
    F=F./epsi;
    F=F+E2;    
    E2new=solve_system_E2_3_ref(F,meshwxy,meshwz,0.25*h^2);

    % E3
    F=partialE_ref(E1,3,meshwxy,meshwz); 
    mu=eval_mu(xxvec,yvec,zzvec);
    F=F./mu;
    F=partialH_ref(F,1,meshwxy,meshwz);
    F=0.5*h*(partialH_ref(H2,1,meshwxy,meshwz)-partialH_ref(H1,2,meshwxy,meshwz))-0.25*h^2*F;
    epsi=eval_epsilon(xvec,yvec,zzvec);
    F=F./epsi;
    F=F+E3;    
    E3new=solve_system_E3_1_ref(F,meshwxy,meshwz,0.25*h^2);

    
    % H1, H2, H3
    mu=eval_mu(xvec,yyvec,zzvec);
    H1=H1-0.5*h*(partialE_ref(E3,2,meshwxy,meshwz)-partialE_ref(E2new,3,meshwxy,meshwz))./mu;
    mu=eval_mu(xxvec,yvec,zzvec);
    H2=H2-0.5*h*(partialE_ref(E1,3,meshwxy,meshwz)-partialE_ref(E3new,1,meshwxy,meshwz))./mu;
    mu=eval_mu(xxvec,yyvec,zvec);
    H3=H3-0.5*h*(partialE_ref(E2,1,meshwxy,meshwz)-partialE_ref(E1new,2,meshwxy,meshwz))./mu;
    
    E1=E1new; E2=E2new; E3=E3new;


    
    % Second half-step - - - - - - - - - - - - - - - - - - - - - - - - - -
    
    % E1
    F=partialE_ref(E3,1,meshwxy,meshwz); 
    mu=eval_mu(xxvec,yvec,zzvec);
    F=F./mu;
    F=partialH_ref(F,3,meshwxy,meshwz);
    F=0.5*h*(partialH_ref(H3,2,meshwxy,meshwz)-partialH_ref(H2,3,meshwxy,meshwz))-0.25*h^2*F;
    epsi=eval_epsilon(xxvec,yvec,zvec);
    F=F./epsi;
    F=F+E1;    
    E1new=solve_system_E1_3_ref(F,meshwxy,meshwz,0.25*h^2);
    
    % E2
    F=partialE_ref(E1,2,meshwxy,meshwz); 
    mu=eval_mu(xxvec,yyvec,zvec);
    F=F./mu;
    F=partialH_ref(F,1,meshwxy,meshwz);
    F=0.5*h*(partialH_ref(H1,3,meshwxy,meshwz)-partialH_ref(H3,1,meshwxy,meshwz))-0.25*h^2*F;
    epsi=eval_epsilon(xvec,yyvec,zvec);
    F=F./epsi;
    F=F+E2;    
    E2new=solve_system_E2_1_ref(F,meshwxy,meshwz,0.25*h^2);
    
    % E3
    F=partialE_ref(E2,3,meshwxy,meshwz); 
    mu=eval_mu(xvec,yyvec,zzvec);
    F=F./mu;
    F=partialH_ref(F,2,meshwxy,meshwz);
    F=0.5*h*(partialH_ref(H2,1,meshwxy,meshwz)-partialH_ref(H1,2,meshwxy,meshwz))-0.25*h^2*F;
    epsi=eval_epsilon(xvec,yvec,zzvec);
    F=F./epsi;
    F=F+E3;    
    E3new=solve_system_E3_2_ref(F,meshwxy,meshwz,0.25*h^2);
    
    % H1, H2, H3
    mu=eval_mu(xvec,yyvec,zzvec);
    H1=H1-0.5*h*(partialE_ref(E3new,2,meshwxy,meshwz)-partialE_ref(E2,3,meshwxy,meshwz))./mu;
    mu=eval_mu(xxvec,yvec,zzvec);
    H2=H2-0.5*h*(partialE_ref(E1new,3,meshwxy,meshwz)-partialE_ref(E3,1,meshwxy,meshwz))./mu;
    mu=eval_mu(xxvec,yyvec,zvec);
    H3=H3-0.5*h*(partialE_ref(E2new,1,meshwxy,meshwz)-partialE_ref(E1,2,meshwxy,meshwz))./mu;
    
    E1=E1new; E2=E2new; E3=E3new;
    
    
    % Compute L2-norm - - - - - - - - - - - - - - - - - - - - - - - - - - -
    
    if 0
        epsi=eval_epsilon(xxvec,yvec,zvec); norm2E = reshape(epsi.*E1,[],1).^2;
        epsi=eval_epsilon(xvec,yyvec,zvec); norm2E = norm2E + reshape(epsi.*E2,[],1).^2; 
        epsi=eval_epsilon(xvec,yvec,zzvec); norm2E = norm2E + reshape(epsi.*E3,[],1).^2;
        norm2E = sum(norm2E)*meshwxy^2*meshwz;
        
        mu=eval_mu(xvec,yyvec,zzvec); norm2H = reshape(mu.*H1,[],1).^2;
        mu=eval_mu(xxvec,yvec,zzvec); norm2H = norm2H + reshape(mu.*H2,[],1).^2;
        mu=eval_mu(xxvec,yyvec,zvec); norm2H = norm2H + reshape(mu.*H3,[],1).^2;
        norm2H = sum(norm2H)*meshwxy^2*meshwz;
        
        normL2(n)=sqrt(norm2E+norm2H);
    end
    
    % Divergence error - - - - - - - - - - - - - - - - - - - - - - - - - -
    
    if 0
        epsi=eval_epsilon(xxvec,yvec,zvec); 
        temp=partialE_ref(epsi.*E1,1,meshwxy,meshwz); 
        divE=temp(2:end-1,:,:);
        
        epsi=eval_epsilon(xvec,yyvec,zvec); 
        temp=partialE_ref(epsi.*E2,2,meshwxy,meshwz); 
        divE=divE+temp(:,2:end-1,:);
        
        epsi=eval_epsilon(xvec,yvec,zzvec); 
        temp=partialE_ref(epsi.*E3,3,meshwxy,meshwz); 
        divE=divE+temp(:,:,2:end-1);
        
        divEerror(n)=norm(reshape(divE,[],1),inf);
        
        mu=eval_mu(xvec,yyvec,zzvec); 
        s=size(H1); Zero=zeros(1,s(2),s(3));
        temp=cat(1,mu.*H1,Zero); temp=cat(1,Zero,temp);
        divH=partialH_ref(temp,1,meshwxy,meshwz);
        
        mu=eval_mu(xxvec,yvec,zzvec); 
        s=size(H2); Zero=zeros(s(1),1,s(3));
        temp=cat(2,mu.*H2,Zero); temp=cat(2,Zero,temp);
        divH=divH+partialH_ref(temp,2,meshwxy,meshwz);
        
        mu=eval_mu(xxvec,yyvec,zvec); 
        s=size(H3); Zero=zeros(s(1),s(2),1);
        temp=cat(3,mu.*H3,Zero); temp=cat(3,Zero,temp);
        divH=divH+partialH_ref(temp,3,meshwxy,meshwz);
        
        divHerror(n)=norm(reshape(divH,[],1),inf);
        
    end
    % fprintf('%g %% - ',100*n/N)       
end
% close(wb)
fprintf('\n\n')
fprintf('Done. \n\n\n')




