

% Test the convergence of the ADI method for Maxwell's equations with
% variable coefficients.


clear all hidden; clc; close all hidden; drawnow


% Configuration -----------------------------------------------------------

mmaxy=150;   %Mesh in x-y
mmaxz=75;    %Mesh in z
tend=1;
Nvec=round(10.^[1:0.25:3]);

% Consequences ------------------------------------------------------------

hvec=tend./Nvec;
lN=length(Nvec);
meshwxy=1/mmaxy;
meshwz=1/mmaxz;

errorfinal=zeros(lN,1);


% Compute reference solution ----------------------------------------------

% Since we do not have an explicit solution formula, we compare the
% numerical method with itself. This is, of course, quite dangerous.
% Moreover, we only measure the error at the final time.

fprintf('\n\n\n')
fprintf('Computing reference solution ... ')

[E1,E2,E3,H1,H2,H3] = initialdata_ref(mmaxy,mmaxz);

N=max(Nvec)*10;
[E1ref,E2ref,E3ref,H1ref,H2ref,H3ref] = adi_ref(E1,E2,E3,H1,H2,H3,mmaxy,mmaxz,tend,N);

fprintf('done.\n\n\n')


% Main loop ---------------------------------------------------------------

parfor k=1:lN
    [E1,E2,E3,H1,H2,H3] = initialdata_ref(mmaxy,mmaxz);
    N=Nvec(k);
    tic;
    [E1,E2,E3,H1,H2,H3] = adi_ref(E1,E2,E3,H1,H2,H3,mmaxy,mmaxz,tend,N);
    runtime(k)=toc;
    
    errE = sum(reshape(E1-E1ref,[],1).^2 + reshape(E2-E2ref,[],1).^2) ...
        + sum(reshape(E3-E3ref,[],1).^2);
    errE = errE*(meshwxy^2)*meshwz;
    errH = sum(reshape(H1-H1ref,[],1).^2 + reshape(H2-H2ref,[],1).^2) ...
        + sum(reshape(H3-H3ref,[],1).^2);
    errH = errH*(meshwxy^2)*meshwz;
    errorfinal(k)=sqrt(errE+errH);
end
save data

fprintf('\n\n\n')
fprintf('All done.\n\n')

plot_convergence


